// Create the context menu when the extension is installed
chrome.runtime.onInstalled.addListener(() => {
    chrome.contextMenus.create({
        id: "send-to-mixdebrid",
        title: "Generate via MixDebrid",
        contexts: ["link"] // Only show when right-clicking a link <a>
    });
});

// Handle the click event on the context menu
chrome.contextMenus.onClicked.addListener((info, tab) => {
    if (info.menuItemId === "send-to-mixdebrid") {
        const linkUrl = info.linkUrl;

        // Construct the MixDebrid URL with the selected link as a parameter
        const mixDebridUrl = `https://mixdebrid.com/?url=${encodeURIComponent(linkUrl)}`;

        // Open a new tab in the browser navigating to our web application
        chrome.tabs.create({ url: mixDebridUrl });
    }
});
